import { createReadStream } from 'fs';
import { parse } from 'csv-parse';

export async function readCSV(filePath) {
  const results = [];

  return new Promise((resolve, reject) => {
    // Create a read stream for the CSV file
    createReadStream(filePath)
      // Use columns option to automatically map CSV headers to object keys
      .pipe(parse({ columns: true }))
      .on('data', (data) => {
        results.push({
          firstName: data.FirstName,
          lastName: data.LastName,
          birthDate: data.BirthDate,
        });
      })
      .on('end', () => resolve(results))
      .on('error', (error) => reject(error));
  });
}
